<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddForeingKeys extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS = 0');

        // Schema::table('users', function (Blueprint $table) {

        //     $table->foreign('magasin_id')
        //         ->references('id')->on('magasins')
        //         ->onDelete('set null');
        // });

        Schema::table('rewards', function (Blueprint $table) {

            $table->foreign('magasin_id')
                ->references('id')->on('magasins')
                ->onDelete('set null');
        });

        Schema::table('wins', function (Blueprint $table) {

            $table->foreign('user_id')
                ->references('id')->on('users');
     
            $table->foreign('reward_id')
                ->references('id')->on('rewards');
              
            $table->foreign('admin_id')
                ->references('id')->on('admins');
        });
        DB::statement('SET FOREIGN_KEY_CHECKS = 1');

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
