<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
use Maatwebsite\Excel\Facades\Excel;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xls;

use App\Win;


Auth::routes();
Route::get('/export', function() {
    $wins = Win::all();
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    // Add column headers
    $sheet->setCellValue('A1', 'Client');
    $sheet->setCellValue('B1', 'Email');
    $sheet->setCellValue('C1', 'Tel');
    $sheet->setCellValue('D1', 'Ville');
    $sheet->setCellValue('E1', 'Reward');
    $sheet->setCellValue('F1', 'status');

    // Add data to the sheet
    $row = 2;
    foreach ($wins as $win) {
        $sheet->setCellValue('A' . $row, $win->user->name);
        $sheet->setCellValue('B' . $row, $win->user->email);
        $sheet->setCellValue('C' . $row, $win->user->tel);
        $sheet->setCellValue('D' . $row, $win->user->ville ? $win->user->ville->intitule : '');
        $sheet->setCellValue('E' . $row, $win->reward->resultText);
        if($win->isGiven){
            $sheet->setCellValue('F' . $row, 'Date de remise :'.$win->updated_at);
            
        }else{

            $sheet->setCellValue('F' . $row, 'Cadeau non remise');
        }
        $row++;
    }

    // Create a new Xls writer
    $writer = new Xls($spreadsheet);

    // Create a temporary file
    $tempFile = tempnam(sys_get_temp_dir(), 'rewards_').'.xls';

    // Save the spreadsheet to the temporary file
    $writer->save($tempFile);

    // Set the appropriate headers for the file download
    $headers = [
        'Content-Type' => 'application/vnd.ms-excel',
        'Content-Disposition' => 'attachment; filename="Rewards.xls"',
    ];

    // Return the file for download
    return response()->download($tempFile, 'Rewards.xls', $headers)->deleteFileAfterSend(true);
})->middleware('auth');
// Route::get('test',function(){
// 	$win = Win::find(2);
	
//     $user = $win->user; // Assuming the Win model has a relationship with the User model
//     $reward = $win->reward; // Assuming the Win model has a relationship with the Reward model

	
// 	return view('test_bon',compact('win', 'user', 'reward'));
// });
Route::get('/', 'HomeController@welcome');

Route::get('/clear-cache', function() {
    $exitCode = Artisan::call('cache:clear');
    // return what you want
});

Route::get('/welcome', 'HomeController@welcome');

Route::get('/data', 'WheelDataController@wheelData');


// Route::get('/bon', function(){
//       $win = App\Win::first();
//       $user = App\User::first();
//       $reward = App\Reward::first();

//       Mail::to('siempay@gmail.com')->send(new App\Mail\winner($win, $win->user, $win->reward));

// 	return view('email.bon',[
//         'win' => $win,
//         'user' => $user,
//         'reward' => $reward,
//         ]);
// });//->name('home')->middleware('auth:');

Route::get('/wins', 'AdminController@wins')->middleware('auth');
Route::get('/winsData', 'AdminController@winsData')->middleware('auth');
Route::get('/searchWinsData', 'AdminController@searchWinsData');
Route::post('validateCode', 'AdminController@validateCode');
Route::get('/loginAdmin', 'AdminController@login')->name('loginAdmin');
Route::post('/registerAdmin', 'AdminController@register')->name('registerAdmin');
Route::get('/logoutAdmin', 'AdminController@logout')->name('logoutAdmin');

Route::group(['prefix' => 'super'], function() {
    
	Route::get('/addAdmin', 'SuperController@addAdminForm');
	Route::get('/admins', 'SuperController@adminsList');
	Route::get('/getAdmins', 'SuperController@getAdminsList');
	Route::post('/addAdmin', 'SuperController@addAdmin')->name('addAdmin');

	Route::post('/update/admin', 'SuperController@putAdmin');
	Route::post('/delete/admin', 'SuperController@deleteAdmin');

    Route::get('/stats', 'SuperController@stats');
    Route::post('/winsStats', 'SuperController@WinsStats');
    Route::post('/winsChart', 'SuperController@WinsChart');

	Route::get('/export', 'SuperController@export');

})->middleware('auth');
