
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');

window.Vue = require('vue');

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */

Vue.component('register', require('./components/register.vue'));
Vue.component('success', require('./components/success.vue'));
Vue.component('orange', require('./components/orange.vue'));
Vue.component('slider', require('./components/slider.vue'));
Vue.component('wheel', require('./components/wheel.vue'));
Vue.component('deja', require('./components/deja.vue'));

 
new Vue({
    el: '#app',
    components:['wheel','register','orange','tableWins','deja','slider'], 
    data:{
        current: 'register',
        bottomBare: 'orange',
        villes:[],
        magasins:[],
        api_token:'',
        orangeClass : ['col-md-12', 'orange'],
        image:'',
        rewardIntitule:'',
        email:''

    },
    mounted:function(){
    	vm = this
        $('.img-responsive').css('display','inline');

        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
    },
    methods:{
    	getData:function(){
    		$.get('api/welcomeData', function(data) {
				console.log("test",data)
    			vm.villes = data.villes		
    			vm.magasins = data.magasins		
    		});
    	},
    	registerSuccess(token,email){
    		console.log("registerSuccess")
    		vm.current = 'wheel'
    		vm.bottomBare = null

    		vm.api_token = token
    		vm.email = email
    	},
    	gamePlayed(status, data, image, rewardIntitule){
    		if (status == "success") {
    			
    			vm.image = image
    			vm.rewardIntitule = rewardIntitule

    			setTimeout(function(){ 
    				vm.current = "success"
    				vm.bottomBare = null

    			 } , 4500);

    		}else {
    			console.log("gamePlayed error")
    		}
    	},
    	userAlreadyPlayed(){

    		this.current = "deja"
    		this.bottomBare = null
    	},
    },
    watch: {
		current (){
			if (vm.current == "wheel") {
				vm.orangeClass.push("wheelAdded")
			}else{
				vm.orangeClass.pop()
			}

		}
	},

});
