<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Auth::routes();

Route::get('/', 'HomeController@welcome');

Route::get('/clear-cache', function() {
    $exitCode = Artisan::call('cache:clear');
    // return what you want
});

Route::get('/welcome', 'HomeController@welcome');

Route::get('/data', 'WheelDataController@wheelData');


// Route::get('/bon', function(){
//       $win = App\Win::first();
//       $user = App\User::first();
//       $reward = App\Reward::first();

//       Mail::to('siempay@gmail.com')->send(new App\Mail\winner($win, $win->user, $win->reward));

// 	return view('email.bon',[
//         'win' => $win,
//         'user' => $user,
//         'reward' => $reward,
//         ]);
// });//->name('home')->middleware('auth:');

Route::get('/wins', 'AdminController@wins')->middleware('auth');
Route::get('/winsData', 'AdminController@winsData');
Route::get('/searchWinsData', 'AdminController@searchWinsData');
Route::post('validateCode', 'AdminController@validateCode');
Route::get('/loginAdmin', 'AdminController@login')->name('loginAdmin');
Route::post('/registerAdmin', 'AdminController@register')->name('registerAdmin');
Route::get('/logoutAdmin', 'AdminController@logout')->name('logoutAdmin');

Route::group(['prefix' => 'super'], function() {
    
	Route::get('/addAdmin', 'SuperController@addAdminForm');
	Route::get('/admins', 'SuperController@adminsList');
	Route::get('/getAdmins', 'SuperController@getAdminsList');
	Route::post('/addAdmin', 'SuperController@addAdmin')->name('addAdmin');

	Route::post('/update/admin', 'SuperController@putAdmin');
	Route::post('/delete/admin', 'SuperController@deleteAdmin');

    Route::get('/stats', 'SuperController@stats');
    Route::post('/winsStats', 'SuperController@WinsStats');
    Route::post('/winsChart', 'SuperController@WinsChart');

	Route::get('/export', 'SuperController@export');

});