<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateTableWins extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('wins', function (Blueprint $table) {
            $table->increments('id');
            $table->bigInteger('code')->unique();
            $table->integer('user_id')->unsigned();
            $table->integer('reward_id')->unsigned();
            $table->integer('admin_id')->unsigned()->nullable();
            $table->boolean('isGiven')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement('SET FOREIGN_KEY_CHECKS = 0');
        Schema::dropIfExists('wins');
        DB::statement('SET FOREIGN_KEY_CHECKS = 1');
    }
}
