<?php

use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    var $rewards = [ 
				[
				    "intitule" => '3_de_remise',
				    "probability" => 0,
				    "type" => "image",
				    "value" => "media/3_de_remise.svg",
				    "win" => true,
				    "resultText" => "3% de remise sur tout achat sur place",
				    "image" => "img/sc-remise3.png",
				    "userData" => ["score" => 20]
				],[
				    "intitule" => '4_de_remise',
				    "probability" => 0,
				    "type" => "image",
				    "value" => "media/4_de_remise.svg",
				    "win" => true,
				    "resultText" => "4% de remise sur tout achat sur place",
				    "image" => "img/sc-remise4.png",
				    "userData" => ["score" => 3000]
				],[
				    "intitule" => '5_de_remise',
				    "probability" => 8,
				    "type" => "image",
				    "value" => "media/5_de_remise.svg",
				    "win" => false,
				    "resultText" => "5% de remise sur tout achat sur place",
				    "image" => "img/sc-remise5.png",
				    "userData" => ["score" => 40]
				],[
				    "intitule" => '6_de_remise',
				    "probability" => 2,
				    "type" => "image",
				    "value" => "media/6_de_remise.svg",
				    "win" => true,
				    "resultText" => "6% de remise sur tout achat sur place",
				    "image" => "img/sc-remise6.png",
				    "userData" => ["score" => 50]
				],[
				    "intitule" => '500DH',
				    "probability" => 0,
				    "type" => "image",
				    "value" => "media/500DH.svg",
				    "win" => true,
				    "resultText" => "Un bon d'achat de 500DH",
				    "image" => "img/sc-bn500.png",
				    "userData" => ["score" => 50]
				],[
				    "intitule" => '1000DH',
				    "probability" => 0,
				    "type" => "image",
				    "value" => "media/1000DH.svg",
				    "win" => true,
				    "resultText" => "Un bon d'achat de 1000DH",
				    "image" => "img/sc-bn1000.png",
				    "userData" => ["score" => 50]
				],[
				    "intitule" => 'Barre_de_son_AZ',
				    "probability" => 0,
				    "type" => "image",
				    "value" => "media/Barre_de_son_AZ.svg",
				    "win" => true,
				    "resultText" => "Une barre de son AZ",
				    "image" => "img/sc-Barre-de-son-AZATECK.png",
				    "userData" => ["score" => 50]
				],[
				    "intitule" => 'ENISIA_NESPRESSO',
				    "probability" => 0,
				    "type" => "image",
				    "value" => "media/ENISIA_NESPRESSO.svg",
				    "win" => true,
				    "resultText" => "Enisia Nespresso",
				    "image" => "img/cofe.png",
				    "userData" => ["score" => 50]
				],[
				    "intitule" => 'Home_cinema_AZ',
				    "probability" => 0,
				    "type" => "image",
				    "value" => "media/Home_cinema_AZ.svg",
				    "win" => true,
				    "resultText" => "Home cinema AZ Tech",
				    "image" => "img/sc-Home-cinema-AZATECK.png",
				    "userData" => ["score" => 50]
				],[
				    "intitule" => 'Home_cinema',
				    "probability" => 0,
				    "type" => "image",
				    "value" => "media/Home_cinema.svg",
				    "win" => true,
				    "resultText" => "Home cinema",
				    "image" => "img/sc-Home-cinema.png",
				    "userData" => ["score" => 50]
				]
			];
	var $villes = [
		'Casablanca',
		'Sale',
		'Marrakech',
		'Fes',
		'Tanger',
		'Kenitra',
		'Rabat',
	];
	var $magasins = [
		[
			'ville_id' => 1,
			'intitule' => 'magasin 1',
		],[
			'ville_id' => 2,
			'intitule' => 'magasin 2',
		],[
			'ville_id' => 3,
			'intitule' => 'magasin 3',
		],
	];

	var $user = [
		'name' => 'brahim',
		'email' => 'siempay@gmail.com',
		'tel' => 0622445566,
		'ville_id' => 1,
		'magasin_id' => 1,
	];


	var $super = [
		'name' => 'SuperAdmin',
		'email' => 'admin@cosmos.com',
        'password' => '$2y$10$.wtf9YkD0K2m1cX.j7Hq1emTnj/3pv6NUcIDnELC30OUCQDjLWaaG', 
        // 'password' => '$2y$10$7zFzX75HGUdCljdzyzgHNePIsP0xebXBw7w.xxPeK2bmEGF7PAmr.', 
		'tel' => 0622445566,
		'magasin_id' => 1,
	];


	var $normalAdmin = [
		'name' => 'normalAdmin',
		'email' => 'admin@gmail.com',
        'password' => "$2y$10$/wqYIXCiE5E/6Y0gcL39p.MvbqMruHVhaaHk5/fSqUMFbAVZsvtrS", 
		'tel' => 06224455,
		'magasin_id' => 1,
	];

    public function run()
    {
     
    	foreach ($this->villes as $key => $value) {
		    DB::table('villes')->insert([
		   		'intitule' => $value,	
		    ]);  
		}

		foreach ($this->magasins as $key => $value) {
		    DB::table('magasins')->insert([
		   		'ville_id' => $value['ville_id'],	
		   		'intitule' => $value['intitule'],	
		    ]);  
		}

		DB::table('admins')->insert([
		   		'name' => $this->super['name'],	
		   		'email' => $this->super['email'],	
		   		'password' => $this->super['password'],	
		   		'tel' => $this->super['tel'],	
		   		'magasin_id' => $this->super['magasin_id'],	
		    ]);  

		DB::table('admins')->insert([
		   		'name' => $this->normalAdmin['name'],	
		   		'email' => $this->normalAdmin['email'],	
		   		'password' => $this->normalAdmin['password'],	
		   		'tel' => $this->normalAdmin['tel'],	
		   		'magasin_id' => $this->normalAdmin['magasin_id'],	
		    ]);  

		DB::table('users')->insert([
		   		'name' => $this->user['name'],	
		   		'email' => $this->user['email'],	
		   		'tel' => $this->user['tel'],	
		   		'ville_id' => $this->user['ville_id'],	
		   		'magasin_id' => $this->user['magasin_id'],	
		    ]);  

    	foreach ($this->rewards as $key => $value) {	
	 		DB::table('rewards')->insert([
	   			'intitule' => $value['intitule'],
				'probability' => $value["probability"],
				'type' => $value["type"],
				'value' => $value["value"],
				'win' => $value["win"],
				'image' => $value["image"],
				'resultText' => $value["resultText"],
	        ]);    
    	}


 	}
}
