
/**
 * First we will load all of this project's JavaScript dependencies which
 * includes Vue and other libraries. It is a great starting point when
 * building robust, powerful web applications using Vue and Laravel.
 */

require('./bootstrap');
var Highcharts = require('highcharts');
require('highcharts/modules/exporting')(Highcharts);


window.Vue = require('vue');

/**
 * Next, we will create a fresh Vue application instance and attach it to
 * the page. Then, you may begin adding components to this application
 * or customize the JavaScript scaffolding to fit your unique needs.
 */

 // this file concern admin section only

Vue.component('adminsList', require('./components/admin/adminsList.vue'));
Vue.component('tableWins', require('./components/admin/tableWins.vue'));
Vue.component('stats', require('./components/admin/stats.vue'));
Vue.component('users', require('./components/admin/users.vue'));

new Vue({
    el: '#app',
	components:['tableWins','users','adminsList','stats',],
	data:{
		winsByDay:[],
		winsByDayByVille:[],
		total:[],
		remis:[],
		nonRemis:[],
		total2:[],
		remis2:[],
		nonRemis2:[],
		
		villes:[],
		dataVilles:[],

		Rewards:[],
	},
	mounted(){
		var vm = this

			$.ajaxSetup({
	            headers: {
	                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
	            }
	        });
			var vm = this
			$.post('/super/winsChart',{}, function(data) {
				
				vm.villes = data.villes 
				vm.Rewards = data.Rewards
				vm.setData(data.byDay,data.byDayByVille)

			});
	},
	methods:{
		setData(w,z){
			var vm = this
			vm.winsByDay = w
			vm.winsByDayByVille = z

	        $.each(vm.winsByDay,function(index, el) {

	        	vm.total.push(el.countWins)
	       
	        	if (el.isGiven) {vm.remis[index] = el.countWins}
	      		else vm.remis[index] = 0

	        	if (!el.isGiven) {vm.nonRemis.push(el.countWins)}
	      		else vm.nonRemis.push(0)
	        });

			$.each(_.groupBy(z, 'ville'),function(index,v){
				var a = 0
				var b = 0
				var c = 0
		        $.each(v,function(index, el) {
				
					a += el.countWins
	        		
		        	if (el.isGiven) {b += el.countWins}

		        	if (!el.isGiven) {c += el.countWins}

				})

					vm.total2.push(a)
	        		
		        	vm.remis2.push(b)

		        	vm.nonRemis2.push(c)

			})

        	vm.makeChart()


		},
		makeChart(){
			var vm = this
			
			Highcharts.chart('chart', { 
				chart: {
            		type: 'line'
		        },
		        title: {
		            text: 'Bons Gagnés par Jour'
		        },
		        xAxis: {
		            categories: _.map(vm.winsByDay,'day'),
		        },
		        yAxis: {
		            title: {
		                text: 'Bons Gagnés par Jour'
		            }
		        },
		        series: [{
		            name: 'Total',
		            data: vm.total,
		            // data: [0,1,2,3,4],
		        }, {
		            name: 'Remis',
		            // data: [2,4,3,5,4,5,2],
		            data: vm.remis,
		        }, {
		            name: 'Non remis',
		            // data: [8,4,9,7,6],
		            data: vm.nonRemis,
		        }]
        	});


			Highcharts.chart('chart2', { 
				chart: {
            		type: 'bar'
		        },
		        title: {
		            text: 'Bons Gagnés par ville'
		        },
		        xAxis: {
		            categories: _.map(vm.villes,'intitule'),
		        },
		        yAxis: {
		            title: {
		                text: 'Bons Gagnés par ville'
		            }
		        },
		        series: [{
		            name: 'Total',
		            data: vm.total2,
		            // data: [0,1,2,3,4],
		        }, {
		            name: 'Remis',
		            // data: [2,4,3,5,4,5,2],
		            data: vm.remis2,
		        }, {
		            name: 'Non remis',
		            // data: [8,4,9,7,6],
		            data: vm.nonRemis2,
		        }]
        	});
        	

			Highcharts.chart('chart3', { 
				chart: {
            		type: 'bar'
		        },
		        title: {
		            text: 'Bons Gagnés'
		        },
		        xAxis: {
		            categories:  _.map(vm.Rewards, (o)=>{ return _.truncate(o.reward,{'length':20,'separator':' '}) }),
		        },
		        yAxis: {
		            title: {
		                text: 'Bons Gagnés'
		            }
		        },
		        series: [{
		            name: 'Rewards',
		            data: _.map(vm.Rewards,'countRewards'),
		            // data: [0,1,2,3,4],
		        }]
        	});
		}

	}

})